<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use App\Models\Clasificacion;
use App\Http\Requests\StoreclasificacionRequest;
use App\Http\Requests\UpdateclasificacionRequest;

class ClasificacionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request)
        {
        $query=trim($request->get('searchText'));
        $clasificacion=DB::table('clasificacion')
        ->where('CLADescri','LIKE','%'.$query.'%')
        ->orwhere('CLACodigo','LIKE','%'.$query.'%')
        ->orderBy('CLACodigo','desc')
        ->simplePaginate(10);
        return view('clasificacion.index' ,["clasificacion"=>$clasificacion, "searchText"=>$query]);
        }
    
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('clasificacion.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreclasificacionRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $clasificacion = new Clasificacion();
        $clasificacion->CLADescri=$request->get('CLADescri');
        $clasificacion->save();
        return redirect('clasificacion');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\clasificacion  $clasificacion
     * @return \Illuminate\Http\Response
     */
    public function show(clasificacion $clasificacion)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\clasificacion  $clasificacion
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $clasificacion = clasificacion::findOrFail($id);
        return view('clasificacion.edit', compact('clasificacion'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateclasificacionRequest  $request
     * @param  \App\Models\clasificacion  $clasificacion
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $clasificacion=clasificacion::findOrFail($id);
        $clasificacion->CLADescri=$request->get('CLADescri');
        $clasificacion->update();
        return redirect('clasificacion');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\clasificacion  $clasificacion
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        clasificacion::destroy($id);
        return redirect('clasificacion');
    }
}
