<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Contribuyente;
use App\Http\Requests\StoreContribuyenteRequest;
use App\Http\Requests\UpdateContribuyenteRequest;

use Illuminate\Support\Facades\DB;

class ContribuyenteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request)
        {
        $query=trim($request->get('searchText'));
        $contribuyentes=DB::table('contribuyentes')
        ->where('CTBNombre','LIKE','%'.$query.'%')
        ->orwhere('CTBCodigo','LIKE','%'.$query.'%')
        ->orderBy('CTBCodigo','desc')
        ->simplePaginate(10);
        return view('contribuyente.index' ,["contribuyentes"=>$contribuyentes, "searchText"=>$query]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('contribuyente.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreContribuyenteRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $contribuyente = new Contribuyente;
        $contribuyente->CTBNombre=$request->get('CTBNombre');
        $contribuyente->CTBTipDoc=$request->get('CTBTipDoc');
        $contribuyente->CTBNroDoc=$request->get('CTBNroDoc');
        $contribuyente->CTBDirecc=$request->get('CTBDirecc');
        $contribuyente->CTBNroDir=$request->get('CTBNroDir');
        $contribuyente->CTBLugar=$request->get('CTBLugar');
        $contribuyente->CTBNroDep=$request->get('CTBNroDep');
        $contribuyente->CTBCuadra=$request->get('CTBCuadra');
        $contribuyente->CTBManzan=$request->get('CTBManzan');
        $contribuyente->CTBResGer=$request->get('CTBResGer');
        $contribuyente->CTBNrLote=$request->get('CTBNrLote');
        $contribuyente->CTBExoFeI=$request->get('CTBExoFeI');
        $contribuyente->CTBExoFeF=$request->get('CTBExoFeF');
        $contribuyente->CTBExoner=$request->get('CTBExoner');
        $contribuyente->CTBObserv=$request->get('CTBObserv');
        $contribuyente->save();
        return redirect('contribuyente');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Contribuyente  $contribuyente
     * @return \Illuminate\Http\Response
     */
    public function show(Contribuyente $contribuyente)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Contribuyente  $contribuyente
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $contribuyente = Contribuyente::findOrFail($id);
        return view('contribuyente.edit', compact('contribuyente'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateContribuyenteRequest  $request
     * @param  \App\Models\Contribuyente  $contribuyente
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $contribuyente=contribuyente::findOrFail($id);
        $contribuyente->CTBNombre=$request->get('CTBNombre');
        $contribuyente->CTBTipDoc=$request->get('CTBTipDoc');
        $contribuyente->CTBNroDoc=$request->get('CTBNroDoc');
        $contribuyente->CTBDirecc=$request->get('CTBDirecc');
        $contribuyente->CTBLugar=$request->get('CTBLugar');
        $contribuyente->CTBNroDir=$request->get('CTBNroDir');
        $contribuyente->CTBNroDep=$request->get('CTBNroDep');
        $contribuyente->CTBCuadra=$request->get('CTBCuadra');
        $contribuyente->CTBManzan=$request->get('CTBManzan');
        $contribuyente->CTBResGer=$request->get('CTBResGer');
        $contribuyente->CTBNrLote=$request->get('CTBNrLote');
        $contribuyente->CTBExoFeI=$request->get('CTBExoFeI');
        $contribuyente->CTBExoFeF=$request->get('CTBExoFeF');
        $contribuyente->CTBExoner=$request->get('CTBExoner');
        $contribuyente->CTBObserv=$request->get('CTBObserv');
        $contribuyente->update();
        return redirect('contribuyente');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Contribuyente  $contribuyente
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $contribuyente=Contribuyente::findOrFail($id);
        $contribuyente->CTBEstado="I";
        $contribuyente->update();
        return redirect('contribuyente');
    }
}
