<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use App\Models\TipoPredio;
use App\Http\Requests\StoreTipoPredioRequest;
use App\Http\Requests\UpdateTipoPredioRequest;

class TipoPredioController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request)
        {
        $query=trim($request->get('searchText'));
        $tipopredios=DB::table('tipopredios')
        ->where('TIPDescri','LIKE','%'.$query.'%')
        ->orwhere('TIPCodigo','LIKE','%'.$query.'%')
        ->orderBy('TIPCodigo','desc')
        ->simplePaginate(10);
        return view('tipopredio.index' ,["tipopredios"=>$tipopredios, "searchText"=>$query]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('tipopredio.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreTipoPredioRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $tipopredio = new TipoPredio();
        $tipopredio->TIPDescri=$request->get('TIPDescri');
        $tipopredio->save();
        return redirect('tipo_predio');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\TipoPredio  $tipoPredio
     * @return \Illuminate\Http\Response
     */
    public function show(TipoPredio $tipoPredio)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\TipoPredio  $tipoPredio
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $tipopredio = tipopredio::findOrFail($id);
        return view('tipopredio.edit', compact('tipopredio'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateTipoPredioRequest  $request
     * @param  \App\Models\TipoPredio  $tipoPredio
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $tipopredio=TipoPredio::findOrFail($id);
        $tipopredio->TIPDescri=$request->get('TIPDescri');
        $tipopredio->update();
        return redirect('tipo_predio');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\TipoPredio  $tipoPredio
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        TipoPredio::destroy($id);
        return redirect('tipo_predio');
    }
}
