<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use App\Models\Ubicacion;
use App\Http\Requests\StoreubicacionRequest;
use App\Http\Requests\UpdateubicacionRequest;

class UbicacionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request)
        {
        $query=trim($request->get('searchText'));
        $ubicacion=DB::table('ubicacion')
        ->where('UBIDepart','LIKE','%'.$query.'%')
        ->orwhere('UBICodigo','LIKE','%'.$query.'%')
        ->orderBy('UBICodigo','desc')
        ->simplePaginate(10);
        return view('ubicacion.index' ,["ubicacion"=>$ubicacion, "searchText"=>$query]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('ubicacion.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreubicacionRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $ubicacion = new ubicacion;
        $ubicacion->UBIDepart=$request->get('UBIDepart');
        $ubicacion->UBIProvin=$request->get('UBIProvin');
        $ubicacion->UBIDistri=$request->get('UBIDistri');
        $ubicacion->save();
        return redirect('ubicacion');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\ubicacion  $ubicacion
     * @return \Illuminate\Http\Response
     */
    public function show(ubicacion $ubicacion)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\ubicacion  $ubicacion
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $ubicacion = ubicacion::findOrFail($id);
        return view('ubicacion.edit', compact('ubicacion'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateubicacionRequest  $request
     * @param  \App\Models\ubicacion  $ubicacion
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $ubicacion=Ubicacion::findOrFail($id);
        $ubicacion->UBIDepart=$request->get('UBIDepart');
        $ubicacion->UBIProvin=$request->get('UBIProvin');
        $ubicacion->UBIDistri=$request->get('UBIDistri');
        $ubicacion->update();
        return redirect('ubicacion');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ubicacion  $ubicacion
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $ubicacion=ubicacion::findOrFail($id);
        $ubicacion->UBIEstado="I";
        $ubicacion->update();
        return redirect('ubicacion');
    }
}
