<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use App\Models\via;
use App\Http\Requests\StoreviaRequest;
use App\Http\Requests\UpdateviaRequest;

class ViaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request)
        {
        $query=trim($request->get('searchText'));
        $vias=DB::table('vias')
        ->where('VIACodigo','LIKE','%'.$query.'%')
        ->orwhere('VIAdescri','LIKE','%'.$query.'%')
        ->orderBy('VIACodigo','desc')
        ->simplePaginate(10);
        return view('vias.index' ,["vias"=>$vias, "searchText"=>$query]);
        }
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('vias.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreviaRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $via = new via;
        $via->VIADescri=$request->get('VIADescri');
        $via->VIATipVia=$request->get('VIATipVia');
        $via->VIACdrIni=$request->get('VIACdrIni');
        $via->VIACdrFin=$request->get('VIACdrFin');
        $via->VIALado=$request->get('VIALado');
        $via->save();
        return redirect('via');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\via  $via
     * @return \Illuminate\Http\Response
     */
    public function show(via $via)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\via  $via
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $via = via::findOrFail($id);
        return view('vias.edit', compact('via'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateviaRequest  $request
     * @param  \App\Models\via  $via
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $via=via::findOrFail($id);
        $via->VIADescri=$request->get('VIADescri');
        $via->VIATipVia=$request->get('VIATipVia');
        $via->VIACdrIni=$request->get('VIACdrIni');
        $via->VIACdrFin=$request->get('VIACdrFin');
        $via->VIALado=$request->get('VIALado');
        $via->update();
        return redirect('via');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\via  $via
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        via::destroy($id);
        return redirect('via');
    }
}
