@extends('layouts.panel')
@section('content')
<nav class="navbar navbar-top navbar-expand-md navbar-dark" id="navbar-main">
    <div class="container-fluid">
      <!-- Brand -->
      <a class="h4 mb-0 text-white text-uppercase d-none d-lg-inline-block" href="#">Categorias de predio</a>
      <!-- Form -->
      {!! Form::open(array('url'=>'categoria_predio','method'=>'GET','autocomplete'=>'off','role'=>'search')) !!}
      <div class="navbar-search navbar-search-dark form-inline mr-0 d-none d-md-flex ml-lg-auto">
        <div class="form-group mb-0">
          <div class="input-group input-group-alternative mr-1">
            <div class="input-group-prepend">
              <span class="input-group-text"><i class="fas fa-search"></i></span>
            </div>
            <input class="form-control" name="searchText" placeholder="Ingrese código o de predio..." value="{{$searchText}}">> 
          </div>
          <button type="submit" class="btn btn-secondary">Buscar</button>
        </div>
      </div>
      {!! Form::close() !!}
  </nav>
  <div class="header pb-8 pt-6 pt-md-5" style="background-color: #74797d;">
  </div>
  <div class="container-fluid mt--7">
    <div class="row">
        <div class="col">
          <div class="card shadow">
            <div class="card-header border-0 form-inline">
              <h3 class="mb-0">Listado de categorias de predios</h3>
              <a class="btn btn-success mr-0 d-none d-md-flex ml-lg-auto" href="{{url('categoria_predio/create')}}">Agregar categoría a un predio</a>
            </div>
            <div class="table-responsive">
              <table class="table align-items-center table-flush">
                <thead style="background-color:#008080;  color: white;">
                  <tr>
                    <th scope="col">Codigo</th>
                    <th scope="col">Codigo de predio</th>
                    <th scope="col">CAPNroPre</th>
                    <th scope="col">Numero de niveles</th>
                    <th scope="col">Año de construccion</th>
                    <th scope="col">Categoría de muros</th>
                    <th scope="col">Categoría de techos</th>
                    <th scope="col">Categoría de muros</th>
                    <th scope="col">Categoría de pisos</th>
                    <th scope="col">Categoría de puertas</th>
                    <th scope="col">CATERE</th>
                    <th scope="col">Categoría de Baños</th>
                    <th scope="col">CATEIN</th>
                    <th scope="col">AREACO</th>
                  </tr>
                </thead>
                <tbody>
                @foreach ($categoriapredio as $cap)
                  <tr>
                      <td scope="col">{{$cap->CAPCodigo}}</td>
                      <td scope="col">{{$cap->PRECodigo}}</td>
                      <td scope="col">{{$cap->CAPNroPre}}</td>
                      <td scope="col">{{$cap->CAPNroNiv}}</td>
                      <td scope="col">{{$cap->CAPAñoCon}}</td>
                      <td scope="col">{{$cap->CAPCateMU}}</td>
                      <td scope="col">{{$cap->CAPCateTE}}</td>
                      <td scope="col">{{$cap->CAPCatePI}}</td>
                      <td scope="col">{{$cap->CAPCatePU}}</td>
                      <td scope="col">{{$cap->CAPCateRE}}</td>
                      <td scope="col">{{$cap->CAPCateBA}}</td>
                      <td scope="col">{{$cap->CAPCateIN}}</td>
                      <td scope="col">{{$cap->CAPAreaCo}}</td>
                        <td class="text-left">
                            <div class="dropdown">
                              <a class="btn btn-sm btn-icon-only text-light" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v"></i>
                              </a>
                              <div class="dropdown-menu dropdown-menu-right dropdown-menu-arrow">
                                <a class="dropdown-item text-blue" href="{{url('/categoria_predio/' .$cap->CAPCodigo.'/edit')}}">Editar</a>
                                {{-- <a href=""  class="dropdown-item text-red" data-toggle="modal" data-target="#modalEliminar{{$cla->CLACodigo}}">Eliminar</a> --}}
                                {{-- @include('clasificacion.modal') --}}
                                <form action="{{url('/categoria_predio/' .$cap->CAPCodigo)}}" method="post">
                                    @csrf
                                    {{method_field('DELETE')}}
                                    <button type="submit" class="dropdown-item text-red" onclick="return confirm('¿Seguro de eliminar la categoria y todos los datos?')">Eliminar</button>
                                </form>
                              </div>
                            </div>
                        </td>
                  </tr>
                @endforeach
                </tbody>
              </table>
            </div>
            <div class="card-footer py-4">
              <ul class="pagination justify-content-end mb-0">
                {{ $categoriapredio->links() }}
              </ul>
            </div>
          </div>
        </div>
    </div>
  </div>
@endsection