
<?php $__env->startSection('content'); ?>
<nav class="navbar navbar-top navbar-expand-md navbar-dark" id="navbar-main">
    <div class="container-fluid">
      <!-- Brand -->
      <a class="h4 mb-0 text-white text-uppercase d-none d-lg-inline-block" href="#">Categorias de predio</a>
      <!-- Form -->
      <?php echo Form::open(array('url'=>'categoria_predio','method'=>'GET','autocomplete'=>'off','role'=>'search')); ?>

      <div class="navbar-search navbar-search-dark form-inline mr-0 d-none d-md-flex ml-lg-auto">
        <div class="form-group mb-0">
          <div class="input-group input-group-alternative mr-1">
            <div class="input-group-prepend">
              <span class="input-group-text"><i class="fas fa-search"></i></span>
            </div>
            <input class="form-control" name="searchText" placeholder="Ingrese código o de predio..." value="<?php echo e($searchText); ?>">> 
          </div>
          <button type="submit" class="btn btn-secondary">Buscar</button>
        </div>
      </div>
      <?php echo Form::close(); ?>

  </nav>
  <div class="header pb-8 pt-6 pt-md-5" style="background-color: #74797d;">
  </div>
  <div class="container-fluid mt--7">
    <div class="row">
        <div class="col">
          <div class="card shadow">
            <div class="card-header border-0 form-inline">
              <h3 class="mb-0">Listado de categorias de predios</h3>
              <a class="btn btn-success mr-0 d-none d-md-flex ml-lg-auto" href="<?php echo e(url('categoria_predio/create')); ?>">Agregar categoría a un predio</a>
            </div>
            <div class="table-responsive">
              <table class="table align-items-center table-flush">
                <thead style="background-color:#008080;  color: white;">
                  <tr>
                    <th scope="col">Codigo</th>
                    <th scope="col">Codigo de predio</th>
                    <th scope="col">CAPNroPre</th>
                    <th scope="col">Numero de niveles</th>
                    <th scope="col">Año de construccion</th>
                    <th scope="col">Categoría de muros</th>
                    <th scope="col">Categoría de techos</th>
                    <th scope="col">Categoría de muros</th>
                    <th scope="col">Categoría de pisos</th>
                    <th scope="col">Categoría de puertas</th>
                    <th scope="col">CATERE</th>
                    <th scope="col">Categoría de Baños</th>
                    <th scope="col">CATEIN</th>
                    <th scope="col">AREACO</th>
                  </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $categoriapredio; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cap): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                      <td scope="col"><?php echo e($cap->CAPCodigo); ?></td>
                      <td scope="col"><?php echo e($cap->PRECodigo); ?></td>
                      <td scope="col"><?php echo e($cap->CAPNroPre); ?></td>
                      <td scope="col"><?php echo e($cap->CAPNroNiv); ?></td>
                      <td scope="col"><?php echo e($cap->CAPAñoCon); ?></td>
                      <td scope="col"><?php echo e($cap->CAPCateMU); ?></td>
                      <td scope="col"><?php echo e($cap->CAPCateTE); ?></td>
                      <td scope="col"><?php echo e($cap->CAPCatePI); ?></td>
                      <td scope="col"><?php echo e($cap->CAPCatePU); ?></td>
                      <td scope="col"><?php echo e($cap->CAPCateRE); ?></td>
                      <td scope="col"><?php echo e($cap->CAPCateBA); ?></td>
                      <td scope="col"><?php echo e($cap->CAPCateIN); ?></td>
                      <td scope="col"><?php echo e($cap->CAPAreaCo); ?></td>
                        <td class="text-left">
                            <div class="dropdown">
                              <a class="btn btn-sm btn-icon-only text-light" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v"></i>
                              </a>
                              <div class="dropdown-menu dropdown-menu-right dropdown-menu-arrow">
                                <a class="dropdown-item text-blue" href="<?php echo e(url('/categoria_predio/' .$cap->CAPCodigo.'/edit')); ?>">Editar</a>
                                
                                
                                <form action="<?php echo e(url('/categoria_predio/' .$cap->CAPCodigo)); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <?php echo e(method_field('DELETE')); ?>

                                    <button type="submit" class="dropdown-item text-red" onclick="return confirm('¿Seguro de eliminar la categoria y todos los datos?')">Eliminar</button>
                                </form>
                              </div>
                            </div>
                        </td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
            <div class="card-footer py-4">
              <ul class="pagination justify-content-end mb-0">
                <?php echo e($categoriapredio->links()); ?>

              </ul>
            </div>
          </div>
        </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.panel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jsalazar/public_html/imppredial/resources/views/categoriapredio/index.blade.php ENDPATH**/ ?>