<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use App\Models\CategoriaPredio;
use App\Http\Requests\StoreCategoriaPredioRequest;
use App\Http\Requests\UpdateCategoriaPredioRequest;

class CategoriaPredioController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request)
        {
        $query=trim($request->get('searchText'));
        $categoriapredio=DB::table('categoriadepredios')
        ->where('CAPCodigo','LIKE','%'.$query.'%')
        ->orderBy('CAPCodigo','desc')
        ->simplePaginate(10);
        return view('categoriapredio.index' ,["categoriapredio"=>$categoriapredio, "searchText"=>$query]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $predios = DB::table('predios')->get();
        return view('categoriapredio.create', ["predios"=>$predios,]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreCategoriaPredioRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreCategoriaPredioRequest $request)
    {
        $datoscategoriapredio = request()->except('_token');
        CategoriaPredio::insert($datoscategoriapredio);
        return redirect('categoria_predio');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\CategoriaPredio  $categoriaPredio
     * @return \Illuminate\Http\Response
     */
    public function show(CategoriaPredio $categoriaPredio)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\CategoriaPredio  $categoriaPredio
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $predios = DB::table('predios')->get();
        $categoriapredio =CategoriaPredio::findOrFail($id);
        return view('categoriapredio.edit', ["predios"=>$predios, "categoriapredio"=>$categoriapredio,]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateCategoriaPredioRequest  $request
     * @param  \App\Models\CategoriaPredio  $categoriaPredio
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateCategoriaPredioRequest $request, $id)
    {
        
        $datoscategoriapredio = request()->except(['_token', '_method']);
        CategoriaPredio::where('CAPCodigo','=',$id)->update($datoscategoriapredio);
        return redirect('categoria_predio');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\CategoriaPredio  $categoriaPredio
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        CategoriaPredio::destroy($id);
        return redirect('categoria_predio');
    }
}
