<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use App\Models\CondicionPropietario;
use App\Http\Requests\StoreCondicionPropietarioRequest;
use App\Http\Requests\UpdateCondicionPropietarioRequest;

class CondicionPropietarioController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request)
        {
        $query=trim($request->get('searchText'));
        $condicionpropietario=DB::table('condicionpropietario')
        ->where('CPRDescri','LIKE','%'.$query.'%')
        ->orwhere('CPRCodigo','LIKE','%'.$query.'%')
        ->orderBy('CPRCodigo','desc')
        ->simplePaginate(10);
        return view('condicionpropietario.index' ,["condicionpropietario"=>$condicionpropietario, "searchText"=>$query]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('condicionpropietario.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreCondicionPropietarioRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $condicionpropietario = new CondicionPropietario();
        $condicionpropietario->CPRDescri=$request->get('CPRDescri');
        $condicionpropietario->save();
        return redirect('condicion_propietario');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\CondicionPropietario  $condicionPropietario
     * @return \Illuminate\Http\Response
     */
    public function show(CondicionPropietario $condicionPropietario)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\CondicionPropietario  $condicionPropietario
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $condicionpropietario = condicionpropietario::findOrFail($id);
        return view('condicionpropietario.edit', compact('condicionpropietario'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateCondicionPropietarioRequest  $request
     * @param  \App\Models\CondicionPropietario  $condicionPropietario
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $condicionpropietario=condicionpropietario::findOrFail($id);
        $condicionpropietario->CPRDescri=$request->get('CPRDescri');
        $condicionpropietario->update();
        return redirect('condicion_propietario');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\CondicionPropietario  $condicionPropietario
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        condicionpropietario::destroy($id);
        return redirect('condicion_propietario');
    }
}
