<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use App\Models\EstadoConservacion;
use App\Http\Requests\StoreEstadoConservacionRequest;
use App\Http\Requests\UpdateEstadoConservacionRequest;

class EstadoConservacionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request)
        {
        $query=trim($request->get('searchText'));
        $estadoconservacion=DB::table('estadoconservacion')
        ->where('ESCDescri','LIKE','%'.$query.'%')
        ->orwhere('ESCCodigo','LIKE','%'.$query.'%')
        ->orderBy('ESCCodigo','desc')
        ->simplePaginate(10);
        return view('estadoconservacion.index' ,["estadoconservacion"=>$estadoconservacion, "searchText"=>$query]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('estadoconservacion.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreEstadoConservacionRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $estadoconservacion = new EstadoConservacion();
        $estadoconservacion->ESCDescri=$request->get('ESCDescri');
        $estadoconservacion->save();
        return redirect('estado_conservacion');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\EstadoConservacion  $estadoConservacion
     * @return \Illuminate\Http\Response
     */
    public function show(EstadoConservacion $estadoConservacion)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\EstadoConservacion  $estadoConservacion
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $estadoconservacion = EstadoConservacion::findOrFail($id);
        return view('estadoconservacion.edit', compact('estadoconservacion'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateEstadoConservacionRequest  $request
     * @param  \App\Models\EstadoConservacion  $estadoConservacion
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $estadoconservacion=EstadoConservacion::findOrFail($id);
        $estadoconservacion->ESCDescri=$request->get('ESCDescri');
        $estadoconservacion->update();
        return redirect('estado_conservacion');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\EstadoConservacion  $estadoConservacion
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        estadoconservacion::destroy($id);
        return redirect('estado_conservacion');
    }
}
