<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use App\Models\Estado;
use App\Http\Requests\StoreestadoRequest;
use App\Http\Requests\UpdateestadoRequest;

class EstadoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request)
        {
        $query=trim($request->get('searchText'));
        $estado=DB::table('estado')
        ->where('ESTDescri','LIKE','%'.$query.'%')
        ->orwhere('ESTCodigo','LIKE','%'.$query.'%')
        ->orderBy('ESTCodigo','desc')
        ->simplePaginate(10);
        return view('estado.index' ,["estado"=>$estado, "searchText"=>$query]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('estado.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreestadoRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $estado = new Estado();
        $estado->ESTDescri=$request->get('ESTDescri');
        $estado->save();
        return redirect('estado');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\estado  $estado
     * @return \Illuminate\Http\Response
     */
    public function show(estado $estado)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\estado  $estado
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $estado = estado::findOrFail($id);
        return view('estado.edit', compact('estado'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateestadoRequest  $request
     * @param  \App\Models\estado  $estado
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $estado=Estado::findOrFail($id);
        $estado->ESTDescri=$request->get('ESTDescri');
        $estado->update();
        return redirect('estado');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\estado  $estado
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        estado::destroy($id);
        return redirect('estado');
    }
}
