<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use App\Models\MaterialPredominante;
use App\Http\Requests\StoreMaterialPredominanteRequest;
use App\Http\Requests\UpdateMaterialPredominanteRequest;

class MaterialPredominanteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request)
        {
        $query=trim($request->get('searchText'));
        $materialpredominante=DB::table('materialpredominante')
        ->where('MPRDescri','LIKE','%'.$query.'%')
        ->orwhere('MPRCodigo','LIKE','%'.$query.'%')
        ->orderBy('MPRCodigo','desc')
        ->simplePaginate(10);
        return view('materialpredominante.index' ,["materialpredominante"=>$materialpredominante, "searchText"=>$query]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('materialpredominante.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreMaterialPredominanteRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $materialpredominante = new MaterialPredominante();
        $materialpredominante->MPRDescri=$request->get('MPRDescri');
        $materialpredominante->save();
        return redirect('material_predominante');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\MaterialPredominante  $materialPredominante
     * @return \Illuminate\Http\Response
     */
    public function show(MaterialPredominante $materialPredominante)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\MaterialPredominante  $materialPredominante
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $materialpredominante = MaterialPredominante::findOrFail($id);
        return view('materialpredominante.edit', compact('materialpredominante'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateMaterialPredominanteRequest  $request
     * @param  \App\Models\MaterialPredominante  $materialPredominante
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $materialpredominante=MaterialPredominante::findOrFail($id);
        $materialpredominante->MPRDescri=$request->get('MPRDescri');
        $materialpredominante->update();
        return redirect('material_predominante');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\MaterialPredominante  $materialPredominante
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        MaterialPredominante::destroy($id);
        return redirect('material_predominante');
    }
}
