<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use App\Models\Contribuyente;
use App\Models\Predio;
use App\Http\Requests\StorePredioRequest;
use App\Http\Requests\UpdatePredioRequest;
use Carbon\Carbon;

class PredioController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request)
        {
        $query=trim($request->get('searchText'));

        $predios = Predio::join('contribuyentes','predios.CTBCodigo','=','contribuyentes.CTBCodigo')
        ->where('contribuyentes.CTBNombre','LIKE','%'.$query.'%')
        ->orderBy('CTBNombre','desc')
        ->simplePaginate(10);
        return view('predio.index' ,["predios"=>$predios, "searchText"=>$query]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $hoy = Carbon::now('America/Lima');
        $condicionpropietario = DB::table('condicionpropietario')->get();
        $estadoconservacion = DB::table('estadoconservacion')->get();
        $clasificacion = DB::table('clasificacion')->get();
        $materialpredominante = DB::table('materialpredominante')->get();
        $tipopredios = DB::table('tipopredios')->get();
        $estado = DB::table('estado')->get();
        $usopredios = DB::table('usopredios')->get();
        $vias = DB::table('vias')->get();
        $contribuyentes = DB::table('contribuyentes')->get();
        $ubicacion = DB::table('ubicacion')->get();
        return view('predio.create', ["clasificacion"=>$clasificacion, "condicionpropietario"=>$condicionpropietario, "estadoconservacion"=>$estadoconservacion, "materialpredominante"=>$materialpredominante,"tipopredios"=>$tipopredios, "estado"=>$estado, "contribuyentes"=>$contribuyentes, "vias"=>$vias, "ubicacion"=>$ubicacion, "usopredios"=>$usopredios,"fecha_hoy"=>$hoy]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StorePredioRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StorePredioRequest $request)
    {
        //$datospredio = request()->except('_token');
        //Predio::insert($datospredio);
        //return redirect('predio');


        $predio = new Predio;
        $datosPredio = $request->get('sltContribuyentes');
        $xdatosPredio = explode('_',$datosPredio);
        $predio->CTBCodigo = $xdatosPredio[0];

        $predio->PREFecIns = $request->get('txtPREFecIns');

        $predio->PREUrbRur = $request->get('txtPREUrbRur');
        $predio->UBICodigo = $request->get('txtUBICodigo');
        $predio->VIACodigo = $request->get('txtVIACodigo');
        $predio->USOCodigo = $request->get('txtUSOCodigo');
        $predio->ESTCodigo = $request->get('txtESTCodigo');
        $predio->TIPCodigo = $request->get('txtTIPCodigo');
        $predio->MPRCodigo = $request->get('txtMPRCodigo');
        $predio->ESCCodigo = $request->get('txtESCCodigo');
        $predio->CPRCodigo = $request->get('txtCPRCodigo');
        $predio->PREAreaTe = $request->get('txtPREAreaTe');
        $predio->PREOtrIns = $request->get('txtPREOtrIns');
        $predio->PREActivi = 'P';
        $predio->PREComent = $request->get('txtPREComent');
        $predio->PRERefUbi = $request->get('txtPRERefUbi');
        $predio->PRELimNor = $request->get('txtPRELimNor');
        $predio->PRELimSur = $request->get('txtPRELimSur');
        $predio->PRELimEst = $request->get('txtPRELimEst');
        $predio->PRELimOes = $request->get('txtPRELimOes');
        $predio->save();
        return redirect('predio');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Predio  $predio
     * @return \Illuminate\Http\Response
     */
    public function show(Predio $predio)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Predio  $predio
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $condicionpropietario = DB::table('condicionpropietario')->get();
        $estadoconservacion = DB::table('estadoconservacion')->get();
        $clasificacion = DB::table('clasificacion')->get();
        $materialpredominante = DB::table('materialpredominante')->get();
        $tipopredios = DB::table('tipopredios')->get();
        $estado = DB::table('estado')->get();
        $usopredios = DB::table('usopredios')->get();
        $vias = DB::table('vias')->get();
        $contribuyentes = DB::table('contribuyentes')->get();
        $ubicacion = DB::table('ubicacion')->get();

        $predio =Predio::findOrFail($id);
        return view('predio.edit', ["predio"=>$predio, "clasificacion"=>$clasificacion, "condicionpropietario"=>$condicionpropietario, "estadoconservacion"=>$estadoconservacion, "materialpredominante"=>$materialpredominante,"tipopredios"=>$tipopredios, "estado"=>$estado, "contribuyentes"=>$contribuyentes, "vias"=>$vias, "ubicacion"=>$ubicacion, "usopredios"=>$usopredios,]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdatePredioRequest  $request
     * @param  \App\Models\Predio  $predio
     * @return \Illuminate\Http\Response
     */
    public function update(UpdatePredioRequest $request, $id)
    {
        $datospredio = request()->except(['_token', '_method']);
        Predio::where('PRECodigo','=',$id)->update($datospredio);
        return redirect('predio');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Predio  $predio
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Predio::destroy($id);
        return redirect('predio');
    }
}
