<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use App\Models\UsoPredios;
use App\Http\Requests\StoreUsoPrediosRequest;
use App\Http\Requests\UpdateUsoPrediosRequest;

class UsoPrediosController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request)
        {
        $query=trim($request->get('searchText'));
        $usopredios=DB::table('usopredios')
        ->where('USODescri','LIKE','%'.$query.'%')
        ->orwhere('USOCodigo','LIKE','%'.$query.'%')
        ->orderBy('USOCodigo','desc')
        ->simplePaginate(10);
        return view('usopredio.index' ,["usopredios"=>$usopredios, "searchText"=>$query]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('usopredio.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreUsoPrediosRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $usopredios = new usopredios();
        $usopredios->USODescri=$request->get('USODescri');
        $usopredios->save();
        return redirect('uso_predio');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\UsoPredios  $usoPredios
     * @return \Illuminate\Http\Response
     */
    public function show(UsoPredios $usoPredios)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\UsoPredios  $usoPredios
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $usopredios = usopredios::findOrFail($id);
        return view('usopredio.edit', compact('usopredios'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateUsoPrediosRequest  $request
     * @param  \App\Models\UsoPredios  $usoPredios
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $usopredios=UsoPredios::findOrFail($id);
        $usopredios->USODescri=$request->get('USODescri');
        $usopredios->update();
        return redirect('uso_predio');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\UsoPredios  $usoPredios
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        UsoPredios::destroy($id);
        return redirect('uso_predio');
    }
}
