@extends('layouts.panel')
@section('content')
<form action="{{url('/predio')}}" method="post">
    @csrf
    <nav class="navbar navbar-top navbar-expand-md navbar-dark" id="navbar-main">
    <div class="container-fluid">
      <!-- Brand -->
      <a class="h4 mb-0 text-white text-uppercase d-none d-lg-inline-block" href="#">Predio</a>
    </div>
    </nav>
    <div class="header pb-8 pt-6 pt-md-5" style="background-color: #74797d">
    </div>
    <div class="container-fluid mt--7">
    <div class="row">
        <div class="col">
          <div class="card shadow">
            <div class="card-header border-0 form-inline bg-info">
              <h3 class="mb-0">Nuevo registro de predio</h3>
            </div>
            <div class="card-body">
                <strong>CONTRIBUYENTE</strong> 
                <div class="row container-fluid" style="margin-top:5px;">
                    <div class="col-sm-4">
                        <div class="input-group ml-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" id="basic-addon1"><i class="ni ni-circle-08"></i></span>
                            </div>
                            <select class="form-control" id="sltContribuyentes" name="sltContribuyentes" onchange="mostrarContribuyentes()">
                                <option value="">Contribuyente</option>
                                @foreach($contribuyentes as $con)
                                <option value="{{$con->CTBCodigo}}_{{$con->CTBTipDoc}}_{{$con->CTBNroDoc}}_{{$con->CTBFecNac}}_{{$con->CTBDirecc}}_{{$con->CTBNroDir}}_{{$con->CTBManzan}}_{{$con->CTBNrLote}}_{{$con->CTBCuadra}}_{{$con->CTBExoner}}_{{$con->CTBResGer}}_{{$con->CTBExoFeI}}_{{$con->CTBExoFeF}}_{{$con->CTBObserv}}">{{$con->CTBNombre}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-sm-2">
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1"><i class="ni ni-pin-3 mr-1"></i>Tipo Doc: |</span>
                                </div>
                                <input id="txtCTBTipDoc" name="txtCTBTipDoc" type="text" class="form-control" style="color: blue">
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-3">
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1"><i class="ni ni-pin-3 mr-1"></i>Nro Doc: |</span>
                                </div>
                                <input id="txtCTBNroDoc" name="txtCTBNroDoc" type="text" class="form-control" style="color: blue">
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-3">
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1"><i class="ni ni-pin-3 mr-1"></i>Fecha Nac.: |</span>
                                </div>
                                <input id="txtCTBFecNac" name="txtCTBFecNac" type="text" class="form-control" style="color: blue">
                            </div>
                        </div>
                    </div>
                </div> <!-- Fin de primera linea-->



                <div class="row container-fluid">    
                    <div class="col-sm-4">
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1"><i class="ni ni-pin-3 mr-1"></i>Dirección: |</span>
                                </div>
                                <input id="txtCTBDirecc" name="txtCTBDirecc" type="text" class="form-control" style="color: blue">
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-2">
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1"><i class="ni ni-pin-3 mr-1"></i>Nro: |</span>
                                </div>
                                <input id="txtCTBNroDir" name="txtCTBNroDir" type="text" class="form-control" style="color: blue">
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-2">
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1"><i class="ni ni-pin-3 mr-1"></i>Manzana: |</span>
                                </div>
                                <input id="txtCTBManzan" name="txtCTBManzan" type="text" class="form-control" style="color: blue">
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-2">
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1"><i class="ni ni-pin-3 mr-1"></i>Lote: |</span>
                                </div>
                                <input id="txtCTBNrLote" name="txtCTBNrLote" type="text" class="form-control" style="color: blue">
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-2">
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1"><i class="ni ni-pin-3 mr-1"></i>Cuadra: |</span>
                                </div>
                                <input id="txtCTBCuadra" name="txtCTBCuadra" type="text" class="form-control" style="color: blue">
                            </div>
                        </div>
                    </div>
            </div> <!-- Fin de segunda línea-->    

            <div class="row container-fluid">    
                <div class="col-sm-2">
                    <div class="form-group">
                    <div class="input-group ml-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" id="basic-addon1"><i class="ni ni-pin-3 mr-1"></i>Exononerado: |</span>
                            </div>
                            <input id="txtCTBExoner" name="txtCTBExoner" type="text" class="form-control" style="color: blue">
                        </div>
                    </div>
                </div>
                <div class="col-sm-2">
                    <div class="input-group ">
                            <div class="input-group-prepend">
                                <span class="input-group-text" id="basic-addon1"><i class="ni ni-pin-3 mr-1"></i>Nro Resoluc.: |</span>
                            </div>
                            <input id="txtCTBResGer" name="txtCTBResGer" type="text" class="form-control" style="color: blue">
                        </div>
                </div>
                <div class="col-sm-2">
                    <div class="input-group ">
                            <div class="input-group-prepend">
                                <span class="input-group-text" id="basic-addon1"><i class="ni ni-pin-3 mr-1"></i>Exo-Fecha Ini.|</span>
                            </div>
                            <input id="txtCTBExoFeI" name="txtCTBExoFeI" type="text" class="form-control" style="color: blue">
                        </div>
                </div>
                <div class="col-sm-2">
                    <div class="input-group ">
                            <div class="input-group-prepend">
                                <span class="input-group-text" id="basic-addon1"><i class="ni ni-pin-3 mr-1"></i>Exo-Fecha Fin.|</span>
                            </div>
                            <input id="txtCTBExoFeF" name="txtCTBExoFeF" type="text" class="form-control" style="color: blue">
                        </div>
                </div>
                <div class="col-sm-4">
                    <div class="input-group ">
                            <div class="input-group-prepend">
                                <span class="input-group-text" id="basic-addon1"><i class="ni ni-pin-3 mr-1"></i>Observ..: |</span>
                            </div>
                            <input id="txtCTBObserv" name="txtCTBObserv" type="text" class="form-control" style="color: blue">
                        </div>
                </div>
            </div> <!-- Fin de tercera línea-->    
            </div>

            <div class="card-footer bg-light">
                <strong>PREDIO</strong> 
                <div class="row container-fluid">
                    <div class="col-sm-3">
                        <div class="form-group ml-1">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1" style="color: black">Fecha Inscripción: |</span>
                                </div>
                                <input name="txtPREFecIns" type="date" class="form-control" value="{{$fecha_hoy->format('Y-m-d')}}">
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-3">
                    <div class="form-group">
                    <div class="selec-group mr-1">
                        <select class="form-control" name="txtPREUrbRur">
                            <option value="U" selected>Predio Urbano</option>
                            <option value="R">Predio Rural</option>
                        </select>
                    </div>
                    </div>  </div>

                    <div class="col-sm-3">
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text" id="basic-addon1" style="color: black;"><i class="ni ni-pin-3"></i>Ubicacion: |</span>
                            </div>
                            <select class="form-control" name="txtUBICodigo">
                                @foreach ($ubicacion as $ubi)
                                    <option value="{{$ubi->UBICodigo}}">{{$ubi->UBIDepart}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-sm-3">
                        <div class="input-group ml-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" id="basic-addon1" style="color: black"><i class="ni ni-pin-3"></i>Via: |</span>
                            </div>
                            <select class="form-control" name="txtVIACodigo">
                                @foreach ($vias as $via)
                                    <option value="{{$via->VIACodigo}}">{{$via->VIADescri}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row container-fluid">
                        <div class="col-sm-3">
                            <div class="input-group">
                                <select class="form-control" name="txtUSOCodigo">
                                    <option value="">Uso Del Predio</option>
                                    @foreach ($usopredios as $uso)
                                        <option value="{{$uso->USOCodigo}}">{{$uso->USODescri}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="input-group mr-1">
                                <select class="form-control" name="txtESTCodigo">
                                    <option value="">estado del predio</option>
                                    @foreach ($estado as $est)
                                        <option value="{{$est->ESTCodigo}}">{{$est->ESTDescri}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="form-group">
                            <div class="input-group ml-1">
                                <select class="form-control" name="txtTIPCodigo">
                                    <option value="" style="color: gray;">Tipo de predio</option>
                                    @foreach ($tipopredios as $tip)
                                        <option value="{{$tip->TIPCodigo}}">{{$tip->TIPDescri}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>  </div>
                        <div class="col-sm-3">
                            <div class="input-group">
                                <select class="form-control" name="txtMPRCodigo">
                                    <option value="" style="color: gray;">Material predominante</option>
                                    @foreach ($materialpredominante as $mpr)
                                        <option value="{{$mpr->MPRCodigo}}">{{$mpr->MPRDescri}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                </div> <!-- Fin primera fila -->

                <div class="row container-fluid">
                    <div class="col-sm-3">
                        <div class="input-group">
                            <select class="form-control" name="txtESCCodigo">
                                <option value="" style="color: black;">Estado de conservación</option>
                                @foreach ($estadoconservacion as $esc)
                                    <option value="{{$esc->ESCCodigo}}">{{$esc->ESCDescri}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="input-group mr-1">
                            <select class="form-control" name="txtCPRCodigo">
                                <option value="" style="color: black;">Clasificacion</option>
                                @foreach ($clasificacion as $cla)
                                    <option value="{{$cla->CLACodigo}}">{{$cla->CLADescri}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>                         

                    <div class="col-sm-3">
                        <div class="form-group ml-1">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1" style="color: black;">Area del Predio: |</span>
                                </div>
                                <input id="name" name="txtPREAreaTe" type="text" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1" style="color: black;">Otras Instalaciones: |</span>
                                </div>
                                <input id="name" name="txtPREOtrIns" type="number" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>  <!-- Fin segunda fila -->     

                <div class="row container-fluid">
                    <div class="col-sm-3">
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1" style="color: black;">Actividad: |</span>
                                </div>
                                <input id="name" name="txtPREActivi" type="text" class="form-control">
                            </div>
                        </div>
                    </div>

                    {{-- <div class="col-sm-3">
                        <div class="form-group mr-1">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1">PreMotDec: |</span>
                                </div>
                                <input id="name" name="PREMotDec" type="text" class="form-control">
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-3">
                        <div class="form-group">
                            <div class="input-group ml-1">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1">Limpieza publica: |</span>
                                </div>
                                <select class="form-control" name="PRELimPub">
                                    <option value="S">SI</option>
                                    <option value="N">NO</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1">Tarifas de limpieza: |</span>
                                </div>
                                <select class="form-control" name="VIACodigo">
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group mr-1">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1" style="color: gray;">Limpieza pagado por: |</span>
                                </div>
                                <input id="name" name="LIPCTBPag" type="text" class="form-control">
                            </div>
                        </div>
                    </div> --}}

                    <div class="col-sm-3">
                        <div class="form-group">
                        <div class="input-group ml-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" id="basic-addon1" style="color: gray;">Condicion propietario: |</span>
                            </div>
                            <select class="form-control" name="txtCPRCodigo">
                                @foreach ($condicionpropietario as $cpr)
                                    <option value="{{$cpr->CPRCodigo}}">{{$cpr->CPRDescri}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>  </div>          
                    {{--<div class="col-sm-3">
                        <div class="form-group">
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text" id="basic-addon1">PREEmitir:</span>
                            </div>
                            <input id="name" name="PREEmitir" type="text" class="form-control">
                        </div>
                        </div>
                    </div>

                    <div class="col-sm-3">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="basic-addon1">PRESusHas:</span>
                                    </div>
                                    <input id="name" name="PRESusHas" type="text" class="form-control">
                                </div>
                            </div>
                    </div>--}}
                       
                    <div class="col-sm-3">
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1" style="color: black;">Comentarios: |</span>
                                </div>
                                <input id="name" name="txtPREComent" type="text" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1" style="color: black;">Ubicacion referencia: |</span>
                                </div>
                                <input id="name" name="txtPRERefUbi" type="text" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>  <!-- Fin segunda fila -->     

                <div class="row container-fluid">
                    <div class="col-sm-3">
                        <div class="form-group ml-1">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1" style="color: black;">Limite norte: |</span>
                                </div>
                                <input id="name" name="txtPRELimNor" type="text" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1" style="color: black;">Limite sur: |</span>
                                </div>
                                <input id="name" name="txtPRELimSur" type="text" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1" style="color: black;">Limite este: |</span>
                                </div>
                                <input id="name" name="txtPRELimEst" type="text" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group mr-1">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1" style="color: black;">Limite oeste: |</span>
                                </div>
                                <input id="name" name="txtPRELimOes" type="text" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>  <!-- Fin segunda fila -->

            <button type="submit" class="btn btn-info mb-2 ml-1">Guardar Datos</button>
            <a href="{{url('predio')}}" class="btn btn- mb-2">Volver</a>



            </div> <!--Fin de card footer -->
          </div> <!--Fin de card shadow -->
        </div> <!--Fin de col -->
    </div> <!--Fin de row -->
  </div> <!--container fluid -->

</form>
@endsection





@push ('scripts')
<script type="text/javascript">
    $(document).ready(function(){mostrarContribuyentes()})

    function mostrarContribuyentes()
    {
        datosContribuyentes = document.getElementById('sltContribuyentes').value.split('_');
        $('#txtCTBTipDoc').val(datosContribuyentes[1]);
        $('#txtCTBNroDoc').val(datosContribuyentes[2]);
        $('#txtCTBFecNac').val(datosContribuyentes[3]);
        $('#txtCTBDirecc').val(datosContribuyentes[4]);
        $('#txtCTBNroDir').val(datosContribuyentes[5]);
        $('#txtCTBManzan').val(datosContribuyentes[6]);        
        $('#txtCTBNrLote').val(datosContribuyentes[7]);
        $('#txtCTBCuadra').val(datosContribuyentes[9]);
        $('#txtCTBExoner').val(datosContribuyentes[12]);
        $('#txtCTBExoFeI').val(datosContribuyentes[13]);
        $('#txtCTBExoFeF').val(datosContribuyentes[14]);
        $('#txtCTBObserv').val(datosContribuyentes[15]);
    }

</script>
@endpush


