@extends('layouts.panel')
@section('content')
<nav class="navbar navbar-top navbar-expand-md navbar-dark" id="navbar-main">
    <div class="container-fluid">
      <!-- Brand -->
      <a class="h4 mb-0 text-white text-uppercase d-none d-lg-inline-block" href="#">Tipos De Predios</a>
      <!-- Form -->
      {!! Form::open(array('url'=>'tipo_predio','method'=>'GET','autocomplete'=>'off','role'=>'search')) !!}
      <div class="navbar-search navbar-search-dark form-inline mr-0 d-none d-md-flex ml-lg-auto">
        <div class="form-group mb-0">
          <div class="input-group input-group-alternative mr-1">
            <div class="input-group-prepend">
              <span class="input-group-text"><i class="fas fa-search"></i></span>
            </div>
            <input class="form-control" name="searchText" placeholder="Ingrese código o tipo depredio..." value="{{$searchText}}">> 
          </div>
          <button type="submit" class="btn btn-secondary">Buscar</button>
        </div>
      </div>
      {!! Form::close() !!}
    </div>
  </nav>
  <div class="header pb-8 pt-6 pt-md-5" style="background-color: #74797d">
  </div>
  <div class="container-fluid mt--7">
      
    <div class="row">
        <div class="col">
          <div class="card shadow">
            <div class="card-header border-0 form-inline">
              <h3 class="mb-0">Lista De Tipos De Predios</h3>
              <a class="btn btn-success mr-0 d-none d-md-flex ml-lg-auto" href="{{url('tipo_predio/create')}}">Nuevo Tipo De Predio</a>
            </div>
            <div class="table-responsive">
              <table class="table align-items-center table-flush">
                <thead style="background-color:#008080;  color: white;">
                  <tr>
                    <th scope="col">Codigo</th>
                    <th scope="col">Tipo</th>
                    <th scope="col">Opciones</th>
                  </tr>
                </thead>
                <tbody>
                    @foreach ($tipopredios as $tip)
                  <tr>
                      <td scope="col">{{$tip->TIPCodigo}}</td>
                      <td scope="col">{{$tip->TIPDescri}}</td>
                        <td class="text-left">
                            <div class="dropdown">
                              <a class="btn btn-sm btn-icon-only text-light" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v"></i>
                              </a>
                              <div class="dropdown-menu dropdown-menu-right dropdown-menu-arrow">
                                <a class="dropdown-item text-blue" href="{{url('/tipo_predio/' .$tip->TIPCodigo.'/edit')}}">Editar</a>
                                {{-- <a href=""  class="dropdown-item text-red" data-toggle="modal" data-target="#modalEliminar{{$cla->CLACodigo}}">Eliminar</a> --}}
                                {{-- @include('clasificacion.modal') --}}
                                <form action="{{url('/tipo_predio/' .$tip->TIPCodigo)}}" method="post">
                                    @csrf
                                    {{method_field('DELETE')}}
                                    <button type="submit" class="dropdown-item text-red" onclick="return confirm('¿Seguro de eliminar el uso de predio?')">Eliminar</button>
                                </form>
                                {{-- <a class="dropdown-item text-red" href="#">Eliminar</a> --}}
                              </div>
                            </div>
                        </td>
                  </tr>
                @endforeach
                </tbody>
              </table>
            </div>
            <div class="card-footer py-4">
              {{ $tipopredios->links() }}
            </div>
          </div>
        </div>
    </div>
      
  </div>
{{-- <div class="row">		
    <div class="col-sm-10">
        <div class="input-group">
            <input id="btn-input" type="text" class="form-control input-md" placeholder="Ingrese código de tipo de predio..." />
            <span class="input-group-btn">
                <button class="btn btn-primary btn-md" id="btn-chat">Buscar</button>
            </span>
        </div>
    </div>
    <div class="form-group form-group-sm col-sm-2">
        <a class="btn btn-lg btn-primary" style="float: right" href="{{url('tipo_predio/create')}}">Agregar</a>
    </div>
</div>
<table class="table table-striped  table-bordered table-condensed table-hover" style="background:white;">
    <thead  style="background-color: #4fa8fb; color: #fff">
        <th style="text-align: center">Cod.</th>
        <th style="text-align: center">Tipo De Predio</th>      
        <th style="text-align: center">Opciones</th>
    </thead>
    <tbody>
        @foreach ($tipopredios as $tip)
        <tr>
            <td style="text-align: center">{{$tip->TIPCodigo}}</td>
            <td style="text-align: center">{{$tip->TIPDescri}}</td>
            <td style="text-align: center">
                <a href="{{url('/tipo_predio/' .$tip->TIPCodigo.'/edit')}}" style="color: green; padding-right: 10px; text-decoration: none">
                    |<span class="icon-editar"></span><span class="icon-nombre"></span>
                </a>
                <form action="{{url('/tipo_predio/' .$tip->TIPCodigo)}}" style="display: inline" method="post">
                    @csrf
                    {{method_field('DELETE')}}
                    |<button type="submit" style="color: red; text-decoration: none; padding-left: 5px; border: none; background: none" onclick="return confirm('¿Seguro de eliminar?')"><span class="icon-eliminar"></span></button>
                </form>
            </td>
        </tr>
        @endforeach
        
    </tbody>                    

</table> --}}
@endsection