
<?php $__env->startSection('content'); ?>


<nav class="navbar navbar-top navbar-expand-md navbar-dark" id="navbar-main">
    <div class="container-fluid">
      <!-- Brand -->
      <a class="h4 mb-0 text-white text-uppercase d-none d-lg-inline-block" href="/contribuyente">Contribuyentes</a>
      <!-- Form -->
      <?php echo Form::open(array('url'=>'contribuyente','method'=>'GET','autocomplete'=>'off','role'=>'search')); ?>

      <div class="navbar-search navbar-search-dark form-inline mr-0 d-none d-md-flex ml-lg-auto">
        <div class="form-group mb-0">
          <div class="input-group input-group-alternative mr-1">
            <div class="input-group-prepend">
              <span class="input-group-text"><i class="fas fa-search"></i></span>
            </div>
            <input class="form-control" name="searchText" placeholder="Ingrese código o nombre de contribuyente..." value="<?php echo e($searchText); ?>">> 
          </div>
          <button type="submit" class="btn btn-secondary">Buscar</button>
        </div>
      <?php echo Form::close(); ?>

      
    </div>
  </nav>
  <div class="header pb-8 pt-6 pt-md-5" style="background-color: #74797d">
  </div>
  <div class="container-fluid mt--7">
      
    <div class="row">
        <div class="col">
          <div class="card shadow">
            <div class="card-header border-0 form-inline">
              <h3 class="mb-0">Lista De Contribuyentes</h3>
              <a class="btn btn-success mr-0 d-none d-md-flex ml-lg-auto" href="<?php echo e(url('contribuyente/create')); ?>">Nuevo Contribuyente</a>
            </div>
            <div class="table-responsive">
              <table class="table align-items-center table-flush table-hover">
                <thead style="background-color:#008080;color: white;font-family:Arial;font-size:300%;">
                  <tr>
                    <th scope="col">Cod.</th>
                    <th scope="col">Nombre</th>
                    <th scope="col">Tip.</th>
                    <th scope="col">Nro Doc.</th>
                    <th scope="col">Fec. Nac</th>
                    <th scope="col">Dirección</th>
                    <th scope="col">Nro.</th>
                    <th scope="col">Lugar</th>                    
                    <th scope="col">Exonerado</th>
                    <th scope="col">Estado</th>
                    <th scope="col">Opciones</th>
                  </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $contribuyentes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ctb): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <td scope="col"><?php echo e($ctb->CTBCodigo); ?></td>
                    <td scope="col"><?php echo e($ctb->CTBNombre); ?></td>
                    <td scope="col"><?php echo e($ctb->CTBTipDoc); ?></td>
                    <td scope="col"><?php echo e($ctb->CTBNroDoc); ?></td>
                    <td scope="col"><?php echo e($ctb->CTBFecNac); ?></td>
                    <td scope="col"><?php echo e($ctb->CTBDirecc); ?></td>
                    <td scope="col"><?php echo e($ctb->CTBNroDir); ?></td>                    
                    <td scope="col"><?php echo e($ctb->CTBLugar); ?></td>
                    <?php if($ctb->CTBExoner=="S"): ?>
                    <td>
                        <span class="badge badge-dot mr-4">
                          <i class="bg-success"></i>
                          <span class="status">SI</span>
                        </span>
                    </td>
                    <?php else: ?>
                    <td>
                        <span class="badge badge-dot mr-4">
                          <i class="bg-warning"></i>
                          <span class="status text-red">NO</span>
                        </span>
                    </td>
                    <?php endif; ?>
                    <?php if($ctb->CTBEstado=="A"): ?>
                    <td>
                        <span class="badge badge-dot mr-4">
                          <i class="bg-success"></i>
                          <span class="status text-green">Activo</span>
                        </span>
                    </td>
                    <?php else: ?>
                    <td>
                        <span class="badge badge-dot mr-4">
                          <i class="bg-warning"></i>
                          <span class="status text-red">Inactivo</span>
                        </span>
                    </td>
                    <?php endif; ?>
                        <td class="text-left">
                            <div class="dropdown">
                              <a class="btn btn-sm btn-icon-only text-light" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v"></i>
                              </a>
                              <div class="dropdown-menu dropdown-menu-right dropdown-menu-arrow">
                                <a class="dropdown-item text-blue" href="<?php echo e(url('/contribuyente/' .$ctb->CTBCodigo.'/edit')); ?>">Editar</a>
                                
                                
                                <form action="<?php echo e(url('/contribuyente/' .$ctb->CTBCodigo)); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <?php echo e(method_field('DELETE')); ?>

                                    <button type="submit" class="dropdown-item text-red" onclick="return confirm('¿Cambiar estado de contribuyente?')">Eliminar</button>
                                </form>
                                
                              </div>
                            </div>
                        </td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
            
            <div class="card-footer py-4">
              <nav aria-label="...">
                
                <ul class="pagination justify-content-end mb-0">
                  <?php echo e($contribuyentes->links()); ?>

                </ul>
              </nav>
            </div>
          </div>
        </div>
    </div>
      
  </div>
  
<?php $__env->stopSection(); ?>
 
<?php echo $__env->make('layouts.panel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jsalazar/public_html/imppredial/resources/views/contribuyente/index.blade.php ENDPATH**/ ?>